#include <stdlib.h>
#include <stddef.h>
#include "exit_if.h"
#include "erreurs.h"
#include "stat.h"

static void calcul_somme(void);

/* Nombre de valeur par bloc de rallongement */
#define NBVPBLOC  256
/* Taille d'un bloc de rallongement */
#define TBLOC     (NBVPBLOC*sizeof(double))

static double *valeurs = NULL;
static size_t taille_de_valeurs = 0;
static int total_valide = 0;
static double total = 0.0;
static int nombre_de_valeurs = 0;


void 
stat_initialiser(void)
{
    if (valeurs != NULL)
    {
        free(valeurs);
        valeurs = NULL;
    }
    taille_de_valeurs = 0;
    total_valide = 0;
    total = 0.0;
    nombre_de_valeurs = 0;
}

void 
stat_entrer(double v)
{
    if (nombre_de_valeurs*sizeof(double) == taille_de_valeurs)
    {
        if (valeurs == NULL)
        {
            /* Creation du vecteur valeurs */
            valeurs = malloc(TBLOC);
            EXIT_IF(valeurs == NULL, err_malloc);
            taille_de_valeurs = TBLOC;
        }
        else
        {
            /* Extension du vecteur valeurs */
            double *valeurs = realloc(valeurs, 
                                      taille_de_valeurs+TBLOC);
            EXIT_IF(valeurs == NULL, err_realloc);
            taille_de_valeurs += TBLOC;
        }
    }
    valeurs[nombre_de_valeurs++] = v;
    total_valide = 0;
}

int 
stat_quantite(void)
{
    return nombre_de_valeurs;
}

double 
stat_total(void)
{
    calcul_somme();
    return total;
}

double 
stat_moyenne(void)
{
    calcul_somme();
    return  total / (double) nombre_de_valeurs;
}
    
static void 
calcul_somme(void)
{
    int i = 0;

    if (total_valide)
        return;

    total = 0;
    while (i < nombre_de_valeurs)
        total += valeurs[i++];
    total_valide = 1;
}
