#include <ctype.h>
#include <stdlib.h> 
#include <stdio.h>
#include <stddef.h>
#include "options.h"
#include "stat.h"
#include "chaine.h"
#include "st.def"

static void lire_donnees(void);
static void afficher_resultats(char*);
static void usage(char *s);

static char options_reconnues[] = 
{ 
    COMMANDE_TOTAL, COMMANDE_MOYENNE, COMMANDE_QUANTITE, '\0' 
};

static int longueur_affichage = LONGUEUR_AFFICHAGE;

int 
main(int argc, char *argv[])
{
    char *options = extraire_options(argv+1, options_reconnues);

    if (options == NULL)
        usage(argv[0]);
    if (*options == '\0')
    {
	/* Par dfaut, toutes les options sont actives */
        free(options);
        options = chaine_dup(options_reconnues);
    }

    lire_donnees();
    afficher_resultats(options);    
    free(options);
    return EXIT_SUCCESS;
}

static void 
lire_donnees(void)
{
    for (;;)
    {
        int n;
        
        if (scanf("%d", &n) == EOF)
            break;
        stat_entrer(n);
    }
}

static void 
afficher_resultats(char *options)
{
    while (*options != '\0')
    {
        switch (*options)
        {
          case COMMANDE_QUANTITE:
            printf("%*d", longueur_affichage, stat_quantite());
            break;

          case COMMANDE_TOTAL:
            printf("%*g", longueur_affichage, stat_total());
            break;

          case COMMANDE_MOYENNE:
            printf("%*g", longueur_affichage, stat_moyenne());
            break;
        }
        options++;
    }
    printf("\n");
}

static void 
usage(char *argv0)
{
    printf("Usage: %s -%s\n", argv0, options_reconnues);
    exit(EXIT_FAILURE);
}
