#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

#define NOMBRE_D_INTERRUPTIONS 5

static void interruption(int);

static jmp_buf avant_la_boucle;
static volatile sig_atomic_t compteur = 0;

int 
main(void) 
{
    signal(SIGINT,  interruption);
    if (setjmp(avant_la_boucle) == 0)
    {
	for (;;)
	    compteur += 10;
    }
    return EXIT_SUCCESS;
}

static void 
interruption(int s) 
{
    static int n = 0;

    signal(SIGINT,  interruption);
    printf("%d\n", compteur);
    if (++n == NOMBRE_D_INTERRUPTIONS)
	longjmp(avant_la_boucle, 1);
}
