#define _POSIX_C_SOURCE 1
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <utime.h>
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <time.h>

static void reculer (char *nom);

int 
main(int argc, char *argv[])
{
    int i;

    for (i = 1; i < argc; i++)
	reculer(argv[i]);

    return EXIT_SUCCESS;
}

static void 
reculer(char *nom)
{
    struct utimbuf temps_fichier;
    struct tm temps_local;
    struct stat caracteristiques;

    if (stat(nom, &caracteristiques) == -1)
    {
	perror(nom);
	return;
    }
    temps_local = *localtime(&(caracteristiques.st_mtime));
    temps_local.tm_sec --;
    temps_fichier.modtime = mktime(&temps_local);
    temps_fichier.actime = caracteristiques.st_atime;
    if (utime(nom, &temps_fichier) == -1)
	perror(nom);
}
