#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#define ENVOYER(s) (envoyer(#s, s))

static void envoyer (char *nom, int signal);
static void handler(int signal);

int 
main(void)
{
    signal(SIGABRT, handler);
    signal(SIGFPE, handler);
    signal(SIGILL, handler);
    signal(SIGINT, handler);
    signal(SIGSEGV, handler);
    signal(SIGTERM, handler);

    ENVOYER(SIGABRT);
    ENVOYER(SIGFPE);
    ENVOYER(SIGILL);
    ENVOYER(SIGINT);
    ENVOYER(SIGSEGV);
    ENVOYER(SIGTERM);

    ENVOYER(SIGSEGV);

    return EXIT_SUCCESS;
}

static void 
handler(int signal)
{
    printf("rception du signal %d\n", signal);
}

static void
envoyer(char *nom, int signal)
{
    printf("Envoi du signal %s -- ", nom);
    fflush(stdout);
    raise(signal);
}
