#include <stdlib.h>
#include <stdio.h>
#include <time.h>

static char *nom_du_jour[] = { "dimanche", "lundi", "mardi", 
			       "mercredi", "jeudi", "vendredi", 
			       "samedi" };
int 
main(int argc, char *argv[])
{
    struct tm temps_decompose;

    if (argc != 4)
    {
	fprintf(stderr, "Usage: %s jour mois anne\n", argv[0]);
	exit(EXIT_FAILURE);
    }
    temps_decompose.tm_mday = strtol(argv[1], NULL, 10);
    temps_decompose.tm_mon = strtol(argv[2], NULL, 10) - 1;    
    temps_decompose.tm_year = strtol(argv[3], NULL, 10) - 1900;    
    temps_decompose.tm_hour = 0;
    temps_decompose.tm_min = 0;
    temps_decompose.tm_sec = 1;
    temps_decompose.tm_isdst = -1;

    if (mktime(&temps_decompose) == -1)
    {
	printf("Non calculable.\n");
	return EXIT_FAILURE;
    }
    printf("Un %s.\n", nom_du_jour[temps_decompose.tm_wday]);

    return EXIT_SUCCESS;
}
