#include <stdlib.h>
#include <stdio.h>
#include "pluriel.h"
#include "generateur.h"
#include "roue_num.h"
#include "totalisateur.h"

static void afficher(totalisateur);
static void f(int );

static int departement = 1;
int 
main(int argc, char *argv[])
{
   int i;
   int n = (argc >= 2 ? atoi(argv[1]) : 1);
   totalisateur plaque = totalisateur_faire();

   if (argc >= 3)
       departement = atoi(argv[2]);

   totalisateur_ajouter_roue(plaque, roue_num_faire('A', 'Z'));
   totalisateur_ajouter_roue(plaque, roue_num_faire('A', 'Z'));
   totalisateur_ajouter_roue(plaque, roue_num_faire('0', '9'));
   totalisateur_ajouter_roue(plaque, roue_num_faire('0', '9'));
   totalisateur_ajouter_roue(plaque, roue_num_faire('0', '9'));

   totalisateur_initialiser(plaque);
   for (i = 0; i < n; i++)
   {
      totalisateur_avancer(plaque);
      afficher(plaque);
   }
   return EXIT_SUCCESS;
}

static void 
afficher(totalisateur c)
{
   generateur_aller_au_debut();
   printf("[ ");
   totalisateur_afficher(c, f);
   printf(" %d ]\n", departement);
}

static void 
f(int v)
{
   static int c1;
   static int c2;

   switch (generateur_suivant())
   {
     case 1:
       c1 = v;
       break;

     case 2:
       c2 = v;
       break;

     case 3:
     case 4:
       printf("%c", v);
       break;

     case 5:
       printf("%c %c%c", v, c1, c2);
       break;
   }
}
