#include <stdlib.h>
#include <assert.h>
#include "instancier.h"
#include "vecteur.h"
#include "pilegen.h"

struct pilegen
{
    vecteur contenu;
    int sommet;
};

pilegen pilegen_faire(void)
{
    INSTANCIER(pilegen);

    recv->contenu = vecteur_faire();
    recv->sommet = 0;
    return recv;
}

void 
pilegen_defaire(pilegen recv)
{
    vecteur_defaire(recv->contenu);
    free(recv);
}

void 
pilegen_empiler(pilegen recv, void *valeur)
{
    vecteur_ecrire(recv->contenu, recv->sommet, valeur);
    (recv->sommet)++;
}

void *
pilegen_depiler(pilegen recv)
{
    assert(!pilegen_vide(recv));
    --(recv->sommet);
    return vecteur_lire(recv->contenu, recv->sommet);
}

void *
pilegen_sommet(pilegen recv)
{
    assert(!pilegen_vide(recv));
    return vecteur_lire(recv->contenu, recv->sommet - 1);
}

int 
pilegen_vide(pilegen recv)
{
    return (recv->sommet == 0);
}

void 
pilegen_mode_bavard(pilegen recv, int mode)
{
    vecteur_mode_bavard(recv->contenu, mode);
}
