#ifndef PILE_H
#define PILE_H

#define PILE_IMPLEMENTATION(type, taille) \
    {\
        type base [taille];\
        type *prochain;\
    }

#define PILE_DECLARER(type, ident, taille) \
    struct PILE_IMPLEMENTATION(type, taille) ident

#define PILE_DEFTYPE(type, ident, taille) \
    struct ident PILE_IMPLEMENTATION(type, taille);\
    typedef struct ident ident

#define PILE_TAILLE(ident)  \
    (sizeof(ident).base/sizeof(ident).base[0])

#define PILE_LIMITE(ident) \
    ((ident).base + PILE_TAILLE((ident)))

#define PILE_INIT(ident) \
    (ident).prochain = ((ident).base)

#define EMPILER(ident,e)     (*(ident).prochain++ = (e))
#define DEPILER(ident)       (*--(ident).prochain)

#define PILE_VIDE(ident) \
    ((ident).prochain == (ident).base)
#define PILE_PLEINE(ident) \
    ((ident).prochain >= PILE_LIMITE(ident))

#define PILE_SOMMET(ident) (*((ident).prochain-1))

#endif  /* PILE_H */
