#include <stdlib.h>
#include <stdio.h>
#include "pgm.h"
#include "erreurs.h"
#include "exit_if.h"

const int largeur = 100;
const int hauteur = 100;

static void message_de_terminaison(void);

int 
main(int argc, char *argv[])
{
    if (argc != 4)
    {
	fprintf(stderr, 
		"Usage: %s largeur hauteur niveau-de-gris\n", 
		argv[0]);
	return EXIT_FAILURE;
    }
    atexit(message_de_terminaison);

    pgm_creer(strtol(argv[1], NULL, 10), strtol(argv[2], NULL, 10));
    pgm_initialiser(strtol(argv[3], NULL, 10));
    pgm_ecrire_image(stdout);
    return EXIT_SUCCESS;
}

static void
message_de_terminaison(void)
{
    if (exit_message == err_malloc)
	fprintf(stderr, 
		"Une erreur mmoire s'est produite durant "
		"la construction de l'image.\n"
		"Vous avez d demander une taille trop grande.\n");
    else
	fprintf(stderr, "Image cre\n");
}
