#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdio.h>
#include "exit_if.h"
#include "erreurs.h"
#include "pgm.h"

static size_t largeur_image;
static size_t hauteur_image;
static pixel *image;

void 
pgm_creer(size_t largeur, size_t hauteur)
{
    image = calloc(sizeof(pixel), largeur*hauteur);
    EXIT_IF(image == NULL, err_malloc);
    largeur_image = largeur;
    hauteur_image = hauteur;
    return;
}

void
pgm_liberer()
{
    free(image);
}

void
pgm_initialiser(pixel couleur_de_fond)
{
    memset(image, couleur_de_fond, largeur_image*hauteur_image);
}
     
pixel
pgm_lire_pixel(size_t i, size_t j)
{
    return *(image + j*largeur_image + i);
}

void 
pgm_ecrire_pixel(size_t i, size_t j, pixel p)
{
    *(image + j*largeur_image + i) = p;
}

void
pgm_ecrire_image(FILE *flot)
{
    fprintf(flot, "P5\n%d %d\n%d\n", 
	    largeur_image, hauteur_image, 255);
    fwrite(image, sizeof(pixel), largeur_image*hauteur_image, flot);
}
