#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stddef.h>
#include "exit_if.h"
#include "erreurs.h"
#include "options.h"

static const char caractere_options = '-';

char *
extraire_options(char **liste_args, char *options_valides)
{
   int ind_option;
   int taille_opt = strlen(options_valides)+1;
   char *liste_options = malloc(taille_opt);

   EXIT_IF(liste_options == 0, err_malloc);

   *liste_options = '\0';
   for (ind_option = 0; *liste_args != NULL; liste_args++)
   {
      char *p = *liste_args;

      if (*p != caractere_options)
          continue;
      if (*++p == '\0')
          return liste_options;
      while (*p != '\0')
      {
         if (strchr(options_valides, *p) == NULL)
         {
            free(liste_options);
            return NULL;
         }
         if (strchr(liste_options, *p) == NULL)
             liste_options[ind_option++] = *p;
         p++;
      }
   }
   return liste_options;
}
