#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "pluriel.h"

static void verifier(char *ch, double v);

int 
main(int argc, char *argv[])
{
    double somme = 0;
    int cardinal = 0;
    char *debut = argv[1];
    char *suite;
    
    errno = 0;
    while (*debut != '\0')
    {
        double v = strtod(debut, &suite);

        verifier(debut, v);
        somme += v;
        cardinal++;
        if (*suite == '\0')
            break;
        debut = suite+1;
    }
    printf("Moyenne: %g (%d valeur%s)\n", 
           somme/cardinal, cardinal, pluriel(cardinal));
    return EXIT_SUCCESS;
}

static void
verifier(char *ch, double v)
{
    if (errno == ERANGE)
    {
        if (v == 0)
            fprintf(stderr, "%s: nombre trop proche de zro\n", ch);
        else if (v == HUGE_VAL)
            fprintf(stderr, "%s: nombre trop grand\n", ch);
        else
            fprintf(stderr, "%s: nombre trop petit\n", ch);
        exit(EXIT_FAILURE);
    }
    errno = 0;
}
