#include <stdio.h>
#include <stdlib.h>

static void ligne_suiv(int, char*, char*);

int 
main(int argc, char *argv[])
{
    if (argc != 5)
    {
        fprintf(stderr, 
                "Usage: %s nb lignes nb colonnes m1 m2\n", 
		argv[0]);
        return EXIT_FAILURE;
    }
    else
    {
        int nb_lignes = 2*atoi(argv[1]);
        int nb_colonnes = atoi(argv[2]);
        char *motif1 = argv[3];
        char *motif2 = argv[4];
        int i;

        for (i = nb_lignes; i > 0; i--) 
            ligne_suiv(nb_colonnes, motif1, motif2);
    }
    return EXIT_SUCCESS;
}

static void 
ligne_suiv(int nombre_de_motifs, char *m1, char *m2) 
{
    static int indice_motif = 0;
    char *motif[2];

    motif[0] =  m1;
    motif[1] =  m2;
    while (nombre_de_motifs > 0) 
    {
        printf("%s%s", motif[indice_motif], motif[1-indice_motif]);
        nombre_de_motifs--;
    }
    printf("\n");
    indice_motif = 1 - indice_motif;
}
