#define _POSIX_C_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

static int construire_modes(char * nom_du_fichier);
static void traiter(int bit, char c1, char c2);
static char modes[10]  = { '\0', };
static int indice_modes;

int 
main(int argc, char *argv[])
{
    int i;

    for (i = 1; i < argc; i++)
    {
        if (construire_modes(argv[i]))
            printf("%s: %s\n", argv[i], modes);
    }
    return EXIT_SUCCESS;
}

static int 
construire_modes(char *nom_du_fichier)
{
    struct stat bufstat;
    mode_t mode;

    if (stat(nom_du_fichier, &bufstat) == -1)
    {
	perror(nom_du_fichier);
        return 0;
    }
    mode = bufstat.st_mode;
    indice_modes = 0;

    traiter(mode & S_IRUSR, 'r', '-');
    traiter(mode & S_IWUSR, 'w', '-');
    if (mode & S_ISUID)
	traiter(mode & S_IXUSR, 's', 'S');
    else
	traiter(mode & S_IXUSR, 'x', '-');
    traiter(mode & S_IRGRP, 'r', '-');
    traiter(mode & S_IWGRP, 'w', '-');
    if (mode & S_ISGID)
	traiter(mode & S_IXGRP, 's', 'S');
    else
	traiter(mode & S_IXGRP, 'x', '-');
    traiter(mode & S_IROTH, 'r', '-');
    traiter(mode & S_IWOTH, 'w', '-');
    traiter(mode & S_IXOTH, 'x', '-');
    return 1;
}

static void
traiter(int bit, char c1, char c2)
{
    if (bit)
	modes[indice_modes] = c1;
    else
	modes[indice_modes] = c2;
    indice_modes++;
}
