#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "chaine.h"
#include "message.h"

static void ecrire_message(char *format, va_list parametres);

static char *entete = NULL;

void 
message(char *format, ...)
{
    va_list parametres;

    va_start(parametres, format);
    ecrire_message(format, parametres);
    va_end(parametres);
}

void
message_fatal(char *format, ...)
{
    va_list parametres;

    va_start(parametres, format);
    ecrire_message(format, parametres);
    va_end(parametres);
    exit(EXIT_FAILURE);
}

void
message_definir_entete(char *e)
{
    if (entete != NULL)
	free(entete);
    entete = chaine_dup(e);
}

static void 
ecrire_message(char *format, va_list parametres)
{
    if (entete != NULL)
	fprintf(stderr, "%s: ", entete);
    vfprintf(stderr, format, parametres);
}
