#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "unites.h"

static void usage(char *s);
static void copier_memoire(char *z1, char *z2, size_t n);

int 
main(int argc, char *argv[])
{
    int taille = argc == 4 ? strtol(argv[1], NULL, 10) : (usage(argv[0]), 0);
    int n = strtol(argv[2], NULL, 10);
    char *zone_1;
    char *zone_2;

    taille *= K;
    zone_1 = malloc(taille);
    zone_2 = malloc(taille);

    if (zone_1 == NULL || zone_2 == NULL)
    {
	perror(argv[0]);
	return EXIT_FAILURE;
    }

    switch (argv[3][0])
    {
      case 'd':
	printf("Copie directe de %d octets %d fois\n", taille, n);
        while (n-- > 0)
            copier_memoire(zone_1, zone_2, taille);
        break;

      case 'c':
	printf("Copie avec memcpy de %d octets %d fois\n", taille, n);
        while (n-- > 0)
            memcpy(zone_1, zone_1, taille);
        break;

      case 'v':
	printf("Copie avec memmove de %d octets %d fois\n", taille, n);
        while (n-- > 0)
            memmove(zone_1, zone_1, taille);
        break;

      default :
	usage(argv[0]);
	/* NOBREAK */
    }
    return EXIT_SUCCESS;
}

static void 
copier_memoire(char *z1, char *z2, size_t nombre)
{
    register char *p1 = z1;
    register char *p2 = z2;
    register size_t n = nombre;

    while (n-- > 0)
        *p1++ = *p2++;
}

static void 
usage(char *s)
{
    fprintf(stderr, "Usage: %s taille-en-K nombre-de-copies {u|c|v}\n", s);
    exit(EXIT_FAILURE);
}
