#define _POSIX_C_SOURCE 1
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

static void printdate(char*, time_t);

int 
main(int argc, char *argv[])
{
    int i;

    for (i = 1; i < argc; i++)
    {
        struct stat statbuf;
        if (stat(argv[i], &statbuf) == -1) 
        {
            perror(argv[i]);
            continue;
        }
        printdate("A", statbuf.st_atime);
        printdate("M", statbuf.st_mtime);
        printdate("C", statbuf.st_ctime);
	printf("%s\n", argv[i]);
    }
    return EXIT_SUCCESS;
}

static void 
printdate(char *s, time_t d)
{
    struct tm *tm = localtime(&d);

    printf("%02d/%02d/%02d-%02d:%02d:%02d%s ", 
	   tm->tm_year+1900, tm->tm_mon+1, tm->tm_mday,
           tm->tm_hour, tm->tm_min, tm->tm_sec, s);
}
