#include <stdlib.h>
#include <stdio.h>
#include "lire_chaine.h"
#include "exit_if.h"
#include "erreurs.h"

#define TAILLE_BLOC 8

char *
lire_chaine(char *prompt)
{
    int taille = TAILLE_BLOC;
    char *tampon = malloc(taille);
    char *p = tampon;

    EXIT_IF(tampon == NULL, err_malloc);

    printf("%s", prompt);
    for (;;) 
    {
        /* Boucle de lecture */
        int c = getchar();

        if (c == EOF)
        {
            free(tampon);
            return NULL;
        }
        *p = c;
        if (*p == '\n') 
        {
            if (p > tampon && *(p-1) == '\\')
            {
                /* annulation du \n (prcd de \) */
                p--;
                continue;
            }
            /* fin de la saisie */
            break;
        }
        if (++p == tampon + taille) 
        {
            /* Agrandissement du tampon de lecture */
# ifdef TRACE
            printf("lire_chaine: %d -> %d\n", taille, 2*taille);
# endif /* TRACE */
            tampon = realloc(tampon, 2*taille);
            EXIT_IF(tampon == NULL, err_realloc);
            p = tampon + taille;
            taille *= 2;
        }
    }
    *p = '\0';
    
    /* Allocation d'une zone de la taille de la chaine */
    p = malloc(p - tampon + 1);
    EXIT_IF(p == NULL, err_malloc);
    strcpy(p, tampon);

    /* Liberation de la memoire intermediaire */
    free(tampon);
    return p;
}
