#define _POSIX_C_SOURCE 1
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include "hms.h"

#define DELAI 5
#define TBUF  256

int 
main(void)
{
    int h;
    int m;
    int s;
    
    fcntl(0, F_SETFL, fcntl(0, F_GETFL) | O_NONBLOCK);
    for (;;) 
    {
	char buffer[TBUF-1];
	int n;
            
	hms(&h, &m, &s);
	n = read(0, buffer, sizeof buffer);

	if (n == -1)
	{
	    if (errno == EAGAIN)
	    {
		printf("[%02d:%02d:%02d] rien  lire\n", h, m, s);
		sleep(DELAI);
		continue;
	    }
	    perror(NULL);
	    return EXIT_FAILURE;
	}

	if (n == 0)
	{
	    printf("[%02d:%02d:%02d] Fin de fichier\n", h, m, s);
	    break;
	}
            
	buffer[n-1] = '\0';
	printf("[%02d:%02d:%02d] lu: \"%s\"\n", h, m, s, buffer);
    }
    return EXIT_SUCCESS;
}
