#define _POSIX_C_SOURCE 1
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>

#include "lecture_zone.h"
#include "terminal.h"
#include "exit_if.h"
#include "erreurs.h"

static char *tampon = NULL;
static int position_tampon;

static int erase(void);

char *
lecture_zone(int taille_zone_lecture, int (*controle)(int))
{
    int caractere_erase;
    int caractere_kill;

    terminal_initialiser(0);
    caractere_erase = terminal_erase();
    caractere_kill = terminal_kill();
    terminal_echo(0); 
    terminal_signaux(0); 
    terminal_controle_de_flux(0); 
    terminal_lecture_par_caractere(1);

    tampon = malloc(taille_zone_lecture+1);
    EXIT_IF(tampon == NULL, err_malloc);
    position_tampon = -1;

    for (;;) 
    {
	char caractere;
	int n = read(0, &caractere, 1);

        if (n != 1 || caractere == '\n') 
            break;

        if (caractere == caractere_erase) 
            erase();
	else if (caractere == caractere_kill) 
	{
            while (erase())
                ;
	}
	else if (!controle(caractere)) 
        {
            write(1, "\a", 1);
        }
        else 
        {
	    if (position_tampon == taille_zone_lecture - 1) 
		erase();
	    position_tampon++;
	    write(1, &caractere, 1);
	    tampon[position_tampon] = caractere;
	}
    }
    terminal_restaurer();
    tampon[position_tampon+1] = '\0';
    return tampon;
}

static int 
erase(void) 
{
    if (position_tampon == -1)
        return 0;
    position_tampon--;
    write(1, "\b \b", 3);
    return 1;
}
