#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <math.h>

#define LONGUEUR_MOT 32
static char *itob(unsigned);

int 
main(int argc, char *argv[])
{
    unsigned u;

    if (argc != 2)
        return EXIT_FAILURE;

    u = strtoul(argv[1], NULL, 10);
    printf("%d s'crit %s en base 2\n", u, itob(u));
    return EXIT_SUCCESS;
}

static char *
itob(unsigned i)
{
    int nombre_de_bits = (int) ceil(log((double) i) / log(2));
    char *bits = malloc(nombre_de_bits + 1);
    char *pb = bits + nombre_de_bits;

    *pb = '\0';
    do 
    {
        assert(pb > bits);
        *--pb = (i & 1);
        assert(*pb=='0' || *pb=='1');
        i >>= 1;
    } 
    while (i);
    return pb;
}
