#define _POSIX_C_SOURCE 1
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

static void usage(char*);

int 
main(int argc, char *argv[])
{
    struct stat statbuf_1;
    struct stat statbuf_2;

    if (argc != 3)
	usage(argv[0]);

    if (stat(argv[1], &statbuf_1) == -1 
	|| stat(argv[2], &statbuf_2) == -1)
    {
	perror(argv[0]);
	return EXIT_FAILURE;
    }

    if (statbuf_1.st_dev == statbuf_2.st_dev 
	&& statbuf_1.st_ino == statbuf_2.st_ino)
	printf("%s et %s rfrencent le mme fichier\n", 
	       argv[1], argv[2]);
    return EXIT_SUCCESS;
}

static void 
usage(char *s)
{
    fprintf(stderr, "Usage: %s chemin_1 chemin_2", s);
    exit(EXIT_FAILURE);
}
