#include <assert.h>
#include "instancier.h"
#include "historique.h"

struct historique
{
    char *debut;
    int taille;
    char *tete;
    char *position_courante;
    int plein;
};

historique 
historique_faire(int taille)
{
    INSTANCIER(historique);

    recv->tete = recv->debut = malloc(taille*sizeof(char));
    recv->taille = taille;
    recv->plein = 0;
    return recv;
}

void 
historique_defaire(historique recv)
{
    free(recv->debut);
    free(recv);
}

void 
historique_ajouter(historique recv, char c)
{
    assert(recv->tete < recv->debut + recv->taille);

    *(recv->tete)++ = c;
    if (recv->tete == recv->debut + recv->taille)
    {
        recv->tete = recv->debut;
        recv->plein = 1;
    }
}

void 
historique_aller_a_la_fin(historique recv)
{
    recv->position_courante = recv->tete;
}

char 
historique_precedent(historique recv)
{
    if (recv->position_courante > recv->debut)
        (recv->position_courante)--;
    else if (recv->plein)
        recv->position_courante = recv->debut + recv->taille -1;
    else if (recv->tete > recv->debut)
        recv->position_courante = recv->tete - 1;
    else
        /* Anneau vide */
        return '\0';
    return *(recv->position_courante);
}
