#include <string.h>
#include "heure_approximative.h"
#include "chaine.h"
#include "ec_tailles.h"

static char *nom_heure[] = 
{
    "", "une", "deux", "trois", "quatre", "cinq", 
    "six", "sept", "huit", "neuf", "dix", "onze"
};
static char *nom_fraction_heure[] = 
{
    "", "cinq", "dix", "et quart", "vingt", "vingt-cinq",
    "et demie", "moins vingt-cinq",  "moins vingt",
     "moins le quart", "moins dix", "moins cinq"
};
static const int precision =
    60/EC_NOMBRE_D_ELEMENTS(nom_fraction_heure);

char *
heure_approximative(int heures, int minutes)
{
    char buffer[256];
    char *demi_journee = "";
    int fraction_heure = (minutes + precision/2.0) / precision;
    int minutes_arrondies = fraction_heure * precision;

    fraction_heure %= EC_NOMBRE_D_ELEMENTS(nom_fraction_heure);
    if (minutes_arrondies > 30)
        heures++;

    if (minutes_arrondies == minutes)
        strcpy(buffer, "exactement ");
    else if (minutes_arrondies < minutes)
        strcpy(buffer, "un peu plus de ");
    else
        strcpy(buffer, "presque ");

    if (heures == 12)
        strcat(buffer, "midi");
    else if (heures == 0 || heures == 24)
        strcat(buffer, "minuit");
    else 
    {
        strcat(buffer, nom_heure[heures % 12]);
        strcat(buffer, " heure");
        if (heures % 12 > 1)
            strcat(buffer, "s");
        if (heures < 12)
            demi_journee = " du matin";
        else if (heures < 18)
            demi_journee = " de l'apres-midi";
        else
            demi_journee = " du soir";
    }
    if (fraction_heure != 0)
        strcat(strcat(buffer, " "), 
	       nom_fraction_heure[fraction_heure]);
    if (demi_journee != NULL)
            strcat(buffer, demi_journee);
    return chaine_dup(buffer);
}
