#define _POSIX_C_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "chaine.h"

static char filtre(char c);

extern char **environ;

int 
main(int argc, char *argv[])
{
    char *motif;
    char *motif_majuscule;
    char **p;

    if (argc != 2)
    {
	fprintf(stderr, "Usage: %s motif\n", argv[0]);
	exit(EXIT_FAILURE);
    }
    motif = chaine_dup(argv[1]);
    motif_majuscule = chaine_fdup(motif, filtre);

    for (p = environ; *p != NULL; p++)
    {
	char *variable = chaine_dup(*p);
	char *valeur = strchr(variable, '=');
	char *valeur_majuscule;

	*valeur++ = '\0';
	valeur_majuscule = chaine_fdup(valeur, filtre);

	if (strstr(valeur_majuscule, motif_majuscule) != NULL)
	    printf("%s = %s\n", variable, valeur);
	free(valeur_majuscule);
	free(variable);
    }
    return EXIT_SUCCESS;
}
 
static char filtre(char c)
{
    if (islower(c))
	return toupper(c);
    return c;
}
