#include <stdarg.h>
#include "generateur.h"

#define VALEUR_INITIALE    1
#define PAS_PAR_DEFAUT     1

#define RECUPERER(parametres, debut, variable) \
  va_start(parametres, debut); \
  variable = va_arg(parametres, int); \
  va_end(parametres);
 
int 
generateur(generateur_message m, ...)
{
    static int valeur_initiale = VALEUR_INITIALE;
    static int valeur_courante = VALEUR_INITIALE;
    static int pas = PAS_PAR_DEFAUT;
    va_list parametres;

    switch (m)
    {
      case Definir_premier :
	RECUPERER(parametres, m, valeur_initiale);
        break;

      case Definir_pas :
	RECUPERER(parametres, m, pas);
        break;

      case Aller_au_debut :
        valeur_courante = valeur_initiale;
        break;

      case Suivant :
      {
        int n = valeur_courante;

        valeur_courante += pas;
        return n;
      }
    }
    return 0;
}
