#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "pgm.h"

#define NOMBRE_DE_NIVEAUX_DE_GRIS 255
#define COULEUR_DE_FOND NOMBRE_DE_NIVEAUX_DE_GRIS

#define LARGEUR 600
#define DEMI_HAUTEUR 150
#define HAUTEUR (2*DEMI_HAUTEUR+1)

const double pi = 3.14159265358979323846264338327;

static void placer_pixel(int i, double y, 
			 double amplitude, int niveau_de_gris); 

int 
main(void)
{
    int i;
    const double echelle = (2.0*pi)/LARGEUR;

    pgm_creer(LARGEUR, HAUTEUR);
    pgm_initialiser(COULEUR_DE_FOND);
    for (i = 1; i <= LARGEUR; i++)
    {
        double x = (double)i*echelle;

        placer_pixel(i, 0.0, 1.0, 200);
        placer_pixel(i, sin(pi*x)/(pi*x), 1.0, 160);
        placer_pixel(i, exp(x), exp(LARGEUR*echelle), 80);
        placer_pixel(i, log(x), log(LARGEUR*echelle), 40);
        placer_pixel(i, floor(x), floor(LARGEUR*echelle), 20);
        placer_pixel(i, cos(x), 1.0, 10);
        placer_pixel(i, sin(x), 1.0, 0);
    }
    pgm_ecrire_image(stdout);
    return EXIT_SUCCESS;
}
 
static void
placer_pixel(int i, double y, double amplitude, int niveau_de_gris)
{
    int j = HAUTEUR - ((y / amplitude) * DEMI_HAUTEUR + DEMI_HAUTEUR);

    if (j < 0 || j >= HAUTEUR)
        return;
    pgm_ecrire_pixel(i, j, niveau_de_gris);
    if (j < HAUTEUR-1)
	pgm_ecrire_pixel(i, j+1, niveau_de_gris);
    if (j > 0)
        pgm_ecrire_pixel(i, j-1, niveau_de_gris);
}
