#define _POSIX_C_SOURCE 1
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include "hms.h"

#define FICHIER_A_VERROUILLER "FLOCK.tst"

static int heures;
static int minutes;
static int secondes;
static int pid;

static void message(char *s);

int 
main(void)
{
    struct flock verrou;
    int fd = open(FICHIER_A_VERROUILLER, O_RDWR|O_CREAT, 
		  S_IRUSR|S_IWUSR);

    if (fd == -1)
    {
	perror(FICHIER_A_VERROUILLER);
	return EXIT_FAILURE;
    }
    pid = getpid();

    verrou.l_whence = SEEK_SET;
    verrou.l_start = 0;
    verrou.l_len = 1;
    verrou.l_type = F_WRLCK;

    for (;;) 
    {
	hms(&heures, &minutes, &secondes);
	if (fcntl(fd, F_SETLK, &verrou) == -1)
	{
	    switch (errno)
	    {
	      case EACCES:
	      case EAGAIN:
		message("Zone inaccessible");
		sleep(1);
		continue;

	      default:
		perror(NULL);
		return EXIT_FAILURE;
	    }
	}
	else
	    break;
    }
    message("Verrouillage de la ressource");
    sleep(2);
    hms(&heures, &minutes, &secondes);

    verrou.l_type = F_UNLCK;
    if (fcntl(fd, F_SETLK, &verrou) == -1)
    {
	perror("[1]");
	return EXIT_FAILURE;
    }
    message("Dverrouillage effectu");
    return EXIT_SUCCESS;
}

static void
message(char *s)
{
    printf("[%5d]  %02d:%02d:%02d : %s\n", 
	   pid, heures, minutes, secondes, s);
}
