#define _POSIX_C_SOURCE 1
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>

static void ecrire(int fd, char *s);

#define M1 "Entre ardoise "
#define M2 "et granit"

int 
main(int argc, char *argv[])
{
    int fd;

    if (argc != 2)
    {
	fprintf(stderr, "Usage: %s FIFO\n", argv[0]);
	exit(EXIT_FAILURE);
    }
    fd = open(argv[1], O_WRONLY);
    if (fd == -1)
    {
	perror(argv[1]);
	exit(EXIT_FAILURE);
    }
    ecrire(fd, M1);
    ecrire(fd, M2);

    printf("[E] crit \"%s\", puis \"%s\"\n", M1, M2);
    sleep(5);
    printf("[E] Fermeture du descripteur ouvert en criture\n");
    close(fd);
    sleep(5);
    printf("[E] Terminaison\n");
    exit(EXIT_SUCCESS);
}

static void
ecrire(int fd, char *s)
{
    write(fd, s, strlen(s));
}
