#include <stdio.h>
#include <stdlib.h>
#include "roue_num.h"

static void afficher(char*, int, int);
static void avancer(roue_num, int);

int 
main(int argc, char *argv[])
{
    int maximum = argc >= 2 ? atoi(argv[1])-1 : 2;
    int vitesse_1 = argc >= 3 ? atoi(argv[2]) : 1;
    int vitesse_2 = argc >= 4 ? atoi(argv[3]) : 1;
    
    roue_num r1 = roue_num_faire(0, maximum);
    roue_num r2 = roue_num_faire(0, maximum);
    
    afficher("Dpart avec\n", roue_num_valeur(r1), 
             roue_num_valeur(r2));

    printf("Rotations\n");
    for (;;)
    {
        avancer(r1, vitesse_1);
        avancer(r2, vitesse_2);
        if (roue_num_valeur(r1) == roue_num_valeur(r2))
            break;
        afficher("", roue_num_valeur(r1),
                 roue_num_valeur(r2));
    }
    afficher("Arrt avec\n", roue_num_valeur(r1),
             roue_num_valeur(r2));

    return EXIT_SUCCESS;
}

static void 
avancer(roue_num r, int vitesse)
{
    while (vitesse > 0)
    {
        roue_num_avancer(r);
        vitesse--;
    }
}

static void 
afficher(char *s, int r1, int r2)
{
    printf("%s[ %2d ][ %2d ]\n", s, r1, r2);
}
