#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <setjmp.h>

#define CARACTERE_INCORRECT 1
#define ECHAPPEMENT_INCORRECT 2
#define DEFAUT_DE_MEMOIRE 3

static char *defiler_entier(int longueur);
static int continuation_ligne_suivante(int c1);
static char *fin_de_la_chaine(int longueur);

static jmp_buf contexte;
static char caractere_incorrect;

int 
main(void)
{
    char *s;

    switch(setjmp(contexte))
    {
      case 0 :
	s = defiler_entier(0);
	break;

      case CARACTERE_INCORRECT :
	fprintf(stderr, "'%c': caractre incorrect\n", 
		caractere_incorrect);
	return EXIT_FAILURE;

      case ECHAPPEMENT_INCORRECT :
	fprintf(stderr, "'\\%c': chappement incorrect\n", 
		caractere_incorrect);
	return EXIT_FAILURE;

      case DEFAUT_DE_MEMOIRE :
	fprintf(stderr, "Dfaut de mmoire\n");
	return EXIT_FAILURE;
    }
    printf("%s\n", s);
    return EXIT_SUCCESS;
}

static char *
defiler_entier(int longueur)
{
    int c = getchar();

    if (c == EOF || isspace(c) || c == '.')
	return fin_de_la_chaine(longueur);
    if (continuation_ligne_suivante(c))
	return defiler_entier(longueur);
    else if (isdigit(c))
    {
	char *s = defiler_entier(longueur + 1);
	
	*--s = c;
	return s;
    }
    else
    {
	caractere_incorrect = c;
	longjmp(contexte, CARACTERE_INCORRECT);
    }
}

static int
continuation_ligne_suivante(int c1)
{
    int c2;

    if (c1 != '\\')
	return 0;
    c2 = getchar();
    if (c2 == '\n')
	return 1;
    caractere_incorrect = c2;
    longjmp(contexte, ECHAPPEMENT_INCORRECT);
}

static char *
fin_de_la_chaine(int longueur)
{
    char *s;

    if (longueur == 0)
	return NULL;
 
    s = malloc(longueur + 1);
    if (s == NULL)
	longjmp(contexte, DEFAUT_DE_MEMOIRE);

    s = s + longueur;
    *s = '\0';
    return s;
}
