#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <stdarg.h>
#include "exit_if.h"
#include "erreurs.h"
#include "concatener.h"

char *
concatener(char *premiere_chaine, ...)
{
    va_list liste_de_chaines;
    size_t longueur = strlen(premiere_chaine);
    char *resultat;
    char *pointeur_fin_resultat;

    va_start(liste_de_chaines, premiere_chaine);
    for (;;)
    {
	char *p = va_arg(liste_de_chaines, char *);

	if (p == NULL)
	    break;
	longueur += strlen(p);
    }
    va_end(liste_de_chaines);

    resultat = malloc(longueur + 1);
    EXIT_IF(resultat == NULL, err_malloc);

    strcpy(resultat, premiere_chaine);
    pointeur_fin_resultat = resultat + strlen(premiere_chaine);

    va_start(liste_de_chaines, premiere_chaine);
    for (;;)
    {
	char *p = va_arg(liste_de_chaines, char *);

	if (p == NULL)
	    break;

	while (*p != '\0')
	    *pointeur_fin_resultat++ = *p++;
    }
    va_end(liste_de_chaines);
    *pointeur_fin_resultat = '\0';

    return resultat;
}
