#include <stdlib.h>
#include <stdio.h>

#include "pluriel.h"

enum etat { Dans_un_mot, Hors_d_un_mot };

int 
main(void) 
{
    int nombre_caracteres = 0;
    int nombre_mots = 0;
    int nombre_lignes = 0;
    enum etat etat = Hors_d_un_mot;
    int c;
    
    for (c = getchar(); c != EOF; c = getchar()) 
    {
        switch (c) 
        {
          case '\n':   
            /* Sparateur de lignes */
            nombre_lignes++;
            /* NOBREAK */
            
          case ' ':
          case '\t':
            /* Sparateur de mots */
            if (etat == Dans_un_mot) 
            {
                nombre_mots++;
                etat = Hors_d_un_mot;
            }
            break;
            
          default:  
            /* Le caractre lu n'est pas un sparateur */
            etat = Dans_un_mot;
            break;
        }
        nombre_caracteres++;
    }
    printf("%d ligne%s - %d mot%s - %d caractre%s\n",
           nombre_lignes, pluriel(nombre_lignes),
           nombre_mots, pluriel(nombre_mots),
           nombre_caracteres, pluriel(nombre_caracteres));
    return EXIT_SUCCESS;
}
