#include <stdlib.h>
#include <string.h>
#include "exit_if.h"
#include "erreurs.h"
#include "chaine.h"

static char*
allouer_chaine(char *source)
{
    char *copie = malloc(strlen(source)+1);

    EXIT_IF(copie == NULL, err_malloc);
    return copie;
}

char *
chaine_dup(char *source)
{
    char *copie = allouer_chaine(source);

    return strcpy(copie, source);
}

char *
chaine_fdup(char *source, char (*filtre)(char))
{
    char *copie = allouer_chaine(source);
    char *p = copie;

    while (*source != '\0')
    {
	*p = filtre(*source);
	p++;
	source++;
    }
    return copie;
}
