#include <errno.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#define META_FORMAT "%%#%c\n"

static void usage(void); 
static unsigned long conversion(char *nombre);

static char *argv0;

int 
main(int argc, char *argv[])
{
    char format[sizeof META_FORMAT];
    char specification = 'u';
    int indice_valeur = 1;
    unsigned long v;

    argv0 = argv[0];
    if (argc == 3)
    {
        switch (argv[1][0])
        {
          case 'o':
          case 'x':
            specification = argv[1][0];
            break;

          default:
            usage();
        }
        indice_valeur = 2;
    }
    else if (argc != 2)
        usage();

    v = conversion(argv[indice_valeur]);
    sprintf(format, META_FORMAT, specification);
    printf(format, v);
    return EXIT_SUCCESS;
}

static unsigned long 
conversion(char *nombre)
{
    unsigned long  v;

    errno = 0;
    v = strtoul(nombre, NULL, 0);
    if (errno == ERANGE)
    {
        fprintf(stderr, "%s: %s: nombre trop grand\n", argv0, nombre);
        exit(EXIT_FAILURE);
    }
    return v;
}

static void
usage(void)
{
    fprintf(stderr, "Usage: %s [o|x] nombre\n", argv0);
    exit(EXIT_FAILURE);
}
