#ifndef ASSERT_H
#define ASSERT_H

#ifndef NDEBUG
#   include <stdio.h>

#   ifdef assert
#       undef assert
#   endif /* assert */

#   define assert(e)  {\
if (!(e)) \
{\
    fprintf(stderr,\
            "%s:ligne %d: assertion \"%s\" non verifiee\n",\
            __FILE__, __LINE__, #e);\
    abort();\
}}
#else
#   define assert(ignore)
#endif /* NDEBUG */

#endif  /* ASSERT_H */
