#define _POSIX_C_SOURCE 1
#include <limits.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>

static int allouer_avec_open(void);
static void allouer_avec_pipe(void);
static void dupliquer(int fd);
static void liberer(int fd);

int 
main(void) 
{
    printf("- Maximum de descripteurs : %ld\n", sysconf(_SC_OPEN_MAX));

    allouer_avec_open();
    allouer_avec_open();
    liberer(2);
    liberer(3);
    dupliquer(1);
    dupliquer(5);
    allouer_avec_pipe();

    while (allouer_avec_open() != -1)
	;
    return EXIT_SUCCESS;
}


static int
allouer_avec_open(void)
{
    int fd = open(".", O_RDONLY);

    printf("open -> %d\n", fd);
    return fd;
}

static void
allouer_avec_pipe(void)
{
    int tube[2];

    if (pipe(tube) == -1)
	printf("pipe -> -1\n");
    else
	printf("pipe -> %d, %d\n", tube[0], tube[1]);
}

static void
dupliquer(int fd)
{
    printf("dup(%d) -> %d\n", fd, dup(fd));
}

static void
liberer(int fd)
{
    printf("close(%d) -> %d\n", fd, close(fd));
}
