#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "lire_chaine.h"
#include "accind.h"

static void usage(char *);

int 
main(int argc, char *argv[])
{
    if (argc != 2)
        usage(argv[0]);
    if (!accind_ouvrir(argv[1]))
        return EXIT_FAILURE;
    for (;;) 
    {
        char *p = lire_chaine("-> ");

        if (p == NULL || *p == '\0')
            break;
        accind_ajouter(p);
        free(p);
    }
    accind_fermer();
    return EXIT_SUCCESS;
}

static void 
usage(char *s)
{
    fprintf(stderr, "Usage: %s fichier\n", s);
    exit(EXIT_FAILURE);
}
