#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "accind.h"

#define SUFFIXE_INDEX ".ndx"
#define SUFFIXE_DONNEES ".enr"

static FILE *accind_ouvriraux(char *prefixe, char *suffixe);

struct index 
{
    long debut;
    size_t longueur;
};

static FILE *flot_index;
static FILE *flot_donnees;

int 
accind_ouvrir(char *nom)
{
    flot_donnees = accind_ouvriraux(nom, SUFFIXE_DONNEES);
    if (flot_donnees == NULL)
        return 0;
    flot_index = accind_ouvriraux(nom, SUFFIXE_INDEX);
    if (flot_index == NULL) 
    {
        fclose(flot_donnees);
        return 0;
    }
    return 1;
}

static FILE *
accind_ouvriraux(char *prefixe, char *suffixe)
{
    char *nom = malloc(strlen(prefixe) + strlen(suffixe) + 1);
    FILE *flot;

    strcpy(nom, prefixe);
    strcat(nom, suffixe);
    flot = fopen(nom, "r+");
    if (flot == NULL)
        flot = fopen(nom, "w+");
    if (flot == NULL)
        perror(nom);
    free(nom);
    return flot;
}    

void 
accind_fermer(void)
{
    fclose(flot_donnees);
    fclose(flot_index);
}

void 
accind_ajouter(char *enregistrement)
{
    struct index index;
    size_t longueur = strlen(enregistrement);
    
    fseek(flot_donnees, 0L, SEEK_END);
    index.debut = ftell(flot_donnees);
    index.longueur = longueur;
    fwrite(enregistrement, sizeof(char), longueur, flot_donnees);
    fseek(flot_index, 0L, SEEK_END);
    fwrite(&index, sizeof index, 1, flot_index);
}

char *
accind_nieme(int rang)
{
    struct index index;
    long decalage = (rang-1) * sizeof index;
    char *enregistrement;
    
    if (fseek(flot_index, decalage, SEEK_SET) != 0)
        return NULL;
    if (fread(&index, sizeof index, 1, flot_index) != 1)
        return NULL;
    if (fseek(flot_donnees, index.debut, SEEK_SET) != 0)
        return NULL;
    enregistrement = malloc(index.longueur+1);
    if (fread(enregistrement, sizeof(char), index.longueur, 
	      flot_donnees) 
        != index.longueur) 
    {
        free(enregistrement);
        return NULL;
    }
    enregistrement[index.longueur] = '\0';
    return enregistrement;
}
