#define _POSIX_C_SOURCE 1
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "accind.h"

#define SUFFIXE_INDEX ".ndx"
#define SUFFIXE_DONNEES ".enr"

static int accind_ouvriraux(char *prefixe, char *suffixe);

struct index 
{
    long debut;
    off_t longueur;
};

static int fd_index;
static int fd_donnees;

int 
accind_ouvrir(char *nom)
{
    fd_donnees = accind_ouvriraux(nom, SUFFIXE_DONNEES);
    if (fd_donnees == -1)
        return 0;
    fd_index = accind_ouvriraux(nom, SUFFIXE_INDEX);
    if (fd_index == -1) 
    {
        close(fd_donnees);
        return 0;
    }
    return 1;
}

static int
accind_ouvriraux(char *prefixe, char *suffixe)
{
    char *nom = malloc(strlen(prefixe) + strlen(suffixe) + 1);
    int fd;

    strcpy(nom, prefixe);
    strcat(nom, suffixe);
    fd = open(nom, O_RDWR|O_CREAT, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
    if (fd == -1)
        perror(nom);
    free(nom);
    return fd;
}    

void 
accind_fermer(void)
{
    close(fd_donnees);
    close(fd_index);
}

void 
accind_ajouter(char *enregistrement)
{
    struct index index;
    off_t longueur = strlen(enregistrement);
    
    index.debut = lseek(fd_donnees, 0, SEEK_END);
    index.longueur = longueur;

    write(fd_donnees, enregistrement, longueur);
    lseek(fd_index, 0, SEEK_END);
    write(fd_index, &index, sizeof index);
}

char *
accind_nieme(int rang)
{
    struct index index;
    off_t decalage = (rang-1) * sizeof index;
    char *enregistrement;
    
    if (lseek(fd_index, decalage, SEEK_SET) != 0)
        return NULL;
    if (read(fd_index, &index, sizeof index) != sizeof index)
        return NULL;
    if (lseek(fd_donnees, index.debut, SEEK_SET) != index.debut)
        return NULL;
    enregistrement = malloc(index.longueur+1);
    if (read(fd_donnees, enregistrement, index.longueur) 
	!= index.longueur)
    {
        free(enregistrement);
        return NULL;
    }
    enregistrement[index.longueur] = '\0';
    return enregistrement;
}
